<?php
require_once __DIR__ . '/../includes/auth.php';
require_role(['supervisor']);
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/mail.php';

$id = $_GET['id'] ?? null;
$action = $_GET['action'] ?? null;

if (!$id || !in_array($action, ['approve','reject'])) {
    die("Invalid request");
}

$newStatus = $action === 'approve' ? 'approved' : 'rejected';
$stmt = $pdo->prepare("UPDATE customers SET status=? WHERE id=?");
$stmt->execute([$newStatus, $id]);

$stmt = $pdo->prepare("SELECT fullname,email,customer_no FROM customers WHERE id=?");
$stmt->execute([$id]);
$cust = $stmt->fetch();

if ($cust) {
    if ($newStatus === 'approved') {
        $subject = "Pendaftaran Anda Disetujui";
        $body = "Halo {$cust['fullname']},<br>Selamat! Pendaftaran internet Anda dengan nomor pelanggan <b>{$cust['customer_no']}</b> telah disetujui supervisor.<br><br>Terima kasih telah memilih PT MAJUIN.";
    } else {
        $subject = "Pendaftaran Anda Ditolak";
        $body = "Halo {$cust['fullname']},<br>Mohon maaf, pendaftaran Anda dengan nomor pelanggan <b>{$cust['customer_no']}</b> ditolak oleh supervisor.<br><br>Silakan hubungi admin PT MAJUIN untuk informasi lebih lanjut.";
    }
    send_mail($cust['email'], $subject, $body);
}

header("Location: customers.php?msg=Status updated");
exit;
